#ifndef __APPLICATION_H
#define __APPLICATION_H

#include "TLR_Types.h"
#include "TLR_Packet.h"
#include "cifXUser.h"

#ifdef WIN32
  #include "conio.h"
#endif

#ifdef __cplusplus
  extern "C" {
#endif  /* _cplusplus */


/*************************************************************************************************
 * @brief This structure is part of all application data.
 * It contains all common data structures independent of the stack or bus.
 */
typedef struct APPLICATION_COMMON_Ttag
{
  /* handle from driver api */
  TLR_HANDLE hDriver;
    
  /* channel handle from driver api */
  TLR_HANDLE hChannel;

  /* default timeout */
  TLR_UINT32 ulTimeout;

  /* receive buffers */
  TLR_UINT8* pabReadBuffer;
  TLR_UINT32 ulReadBufferSize;

  /* transmit buffers */
  TLR_UINT8* pabWriteBuffer;
  TLR_UINT32 ulWriteBufferSize;

} APPLICATION_COMMON_T;


/*************************************************************************************************
 * @brief A application contains at least out of the header with the common elements.
 * Thus we create a data type for such basic applications, so we can easily cast to it.
 */
typedef struct APPLICATION_Ttag
{
  APPLICATION_COMMON_T tCommon;
} APPLICATION_T;



/*************************************************************************************************
 * Below you will find some common functions, 
 * they are implemented by Application.h and can be used by any application.
 */

TLR_RESULT App_SendRecvPkt(APPLICATION_T* ptApp, CIFX_PACKET* ptSendPkt, CIFX_PACKET* ptRecvPkt);
TLR_RESULT App_SendRecvEmptyPkt(APPLICATION_T* ptApp, TLR_UINT32 ulCmd);

/* main entry function which manages the startup of the application */
TLR_RESULT App_Main(APPLICATION_T* ptApp);


/*************************************************************************************************
 * Below you will find some common interface functions, 
 * which must be implemented by all applications.
 */

/* configuration */
TLR_RESULT App_ConfigurePnm(APPLICATION_T* ptApp, CIFX_PACKET* ptSendPkt, CIFX_PACKET* ptRecvPkt);
TLR_RESULT App_CheckPkt(CIFX_PACKET* ptRecvPkt, int32_t cifXError, TLR_UINT32 ulExpCommand, TLR_UINT32 ulExpStatus);

/* resource handling */
TLR_RESULT App_CreateResources(APPLICATION_T** pptApp);
TLR_RESULT App_FreeResources(APPLICATION_T* ptApp);

/* startup screen */
TLR_RESULT App_PromptIntro(APPLICATION_T* ptApp);

/* initialize / finalize application */
TLR_RESULT App_Initialize(APPLICATION_T* ptApp);
TLR_RESULT App_Finalize(APPLICATION_T* ptApp);

/* default packet handler */
void App_HandlePacket(APPLICATION_T* ptApp, CIFX_PACKET* ptPacket);

/* handling of cyclic process data */
void App_HandleProcessData(APPLICATION_T* ptApp);

/*************************************************************************************************/

#ifdef __cplusplus
  }
#endif  /* _cplusplus */


#endif /* #ifndef __APPLICATION_H */
